#install.packages("colorspace")
#install.packages("stringi")
#install.packages("ggplot2")

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("org.Hs.eg.db")
#BiocManager::install("DOSE")
#BiocManager::install("clusterProfiler")
#BiocManager::install("enrichplot")


#library packages
library("clusterProfiler")
library("org.Hs.eg.db")
library("enrichplot")
library("ggplot2")

pvalueFilter=0.05      #p-value filter
qvalueFilter=0.05      #adjusted p-value filter

#define color
colorSel="qvalue"
if(qvalueFilter>0.05){
	colorSel="pvalue"
}
	
setwd("E:\\metabolism\\LGG\\12.TypeDiff\\enrichment\\enrichKEGG")           
rt=read.table("interGene.txt", header=F, sep="\t", check.names=F)     #read input file

#Convert gene name to gene id
genes=unique(as.vector(rt[,1]))
entrezIDs=mget(genes, org.Hs.egSYMBOL2EG, ifnotfound=NA)
entrezIDs=as.character(entrezIDs)
rt=data.frame(genes, entrezID=entrezIDs)
gene=entrezIDs[entrezIDs!="NA"]        
#gene=gsub("c\\(\"(\\d+)\".*", "\\1", gene)
write.table(gene,"gene.txt",quote = F,sep = '\t')

gene2=read.table("gene.txt",sep = "\t",header = T,check.names = 1,row.names = 1)
gene=as.vector(gene2[,1])
#kegg enrichment analysis
kk <- enrichKEGG(gene=gene, organism="hsa", pvalueCutoff=1, qvalueCutoff=1)
KEGG=as.data.frame(kk)
KEGG$geneID=as.character(sapply(KEGG$geneID,function(x)paste(rt$genes[match(strsplit(x,"/")[[1]],as.character(rt$entrezID))],collapse="/")))
KEGG=KEGG[(KEGG$pvalue<pvalueFilter & KEGG$qvalue<qvalueFilter),]
#Save enrichment results
write.table(KEGG, file="KEGG.txt", sep="\t", quote=F, row.names = F)

#Define the number of display pathways
showNum=30
if(nrow(KEGG)<showNum){
	showNum=nrow(KEGG)
}

#barplot
pdf(file="barplot.pdf", width=8.2, height=6)
barplot(kk, drop=TRUE, showCategory=showNum, label_format=100, color=colorSel)
dev.off()

#bubble plot
pdf(file="bubble.pdf", width = 8.2, height = 6)
dotplot(kk, showCategory=showNum, orderBy="GeneRatio",  color=colorSel)
dev.off()

#circos
pdf(file="KEGG_circos.pdf",width = 15,height = 10)
kkx=setReadable(kk, 'org.Hs.eg.db', 'ENTREZID')
cnetplot(kkx, showCategory = 5, circular = TRUE, colorEdge = TRUE,node_label="all")
dev.off()


